﻿//Class ShapeTetrahedron
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ShapePolymorphism
{
    public class ShapeTetrahedron : Shape3D
    {
        private double side;
        public double Length

        {
            get { return side; }
            set
            {
                if (value >= 0)
                {
                    side = value;
                    Area();
                    Volume();
                }
                else
                {
                    MessageBox.Show("Cube side must be positive number", "Invalid number format",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }//end Length
        public ShapeTetrahedron()
        {
            Name = "Tetrahedron";
        }//end constructor

        public override string ToString()
        {
            return "P1.Shape3D." + Name;
        }//end toString

        public override double Area()
        {
            return Math.Sqrt(3) * Math.Pow(side, 2);
        }//end calculateArea

        public override double Volume()
        {
            return (Math.Pow(side, 3)) / (6 * Math.Sqrt(2));
        }//end calculateVolume

        public override double Side()
        {
            return side;
        }//End Side
    }//End class
}//End namespace
